#!/bin/sh

MASTER_PAGE_PING_RESULT_MSG=""
MASTER_PAGE_PING_RESULT_OK=0
MASTER_PAGE_PING_RESULT_ERROR=1

MASTER_PAGE_PING_RESULT_CODE=${MASTER_PAGE_PING_RESULT_ERROR}
MASTER_PAGE_PING_RESULT_ROLLING=0
    
master_page_ping() {
    #dprint 0 "debug" "Enter master_page_ping"

    # assign default value
    local RT_PING_IP="${TP_PING_RESULT_DATA}"
    
	tp_ping \
		"${MASTER_PAGE_PING_TITLE}" \
		"${MASTER_PAGE_PING_TEXT}" \
		"${MASTER_PAGE_PING_LABEL_OK}" \
		"${MASTER_PAGE_PING_LABEL_CANCEL}" \
        "${RT_PING_IP}"
        
        
    #debug_print "${0}" "${LINENO}" "TP_PING_RESULT_CODE: ${TP_PING_RESULT_CODE}"
    case "${TP_PING_RESULT_CODE}" in
    
        "${TP_PING_RESULT_ERROR}")
            MASTER_PAGE_PING_RESULT_CODE=$MASTER_PAGE_PING_RESULT_ERROR
            MASTER_PAGE_PING_RESULT_ROLLING=0
            MASTER_PAGE_PING_RESULT_MSG="${TP_PING_RESULT_MSG}"
            return
            ;;
        
        "${TP_PING_RESULT_CANCEL}")
            MASTER_PAGE_PING_RESULT_CODE=$MASTER_PAGE_PING_RESULT_OK
            MASTER_PAGE_PING_RESULT_ROLLING=-1
            MASTER_PAGE_PING_RESULT_MSG=""
            
            TP_PING_RESULT_DATA=""
            
            return
            ;;
            
        "${TP_PING_RESULT_OK}" )
            ;;
        
        *)
            MASTER_PAGE_PING_RESULT_CODE=$MASTER_PAGE_PING_RESULT_ERROR
            MASTER_PAGE_PING_RESULT_ROLLING=0
            MASTER_PAGE_PING_RESULT_MSG=""
            return
            ;;
    esac

    # apply and error handling

    /bin/ping -c 3 "${TP_PING_RESULT_DATA}" >/tmp/ping_result 2>&1
    local RET_VALUE=$?
    if [ ${RET_VALUE} -ne 0 ]; then
        # try to ping6
        local RET_MSG=`/bin/ping6 -c 3 "${TP_PING_RESULT_DATA}" 2>&1`
        if [ "${RET_MSG}" = "unknown host" ]; then
            RET_MSG="Unable to resolve host."
        fi
    else
	local RET_MSG=`cat /tmp/ping_result`
    fi
    rm -f /tmp/ping_result

	dialog \
		--title     "${PING_TITLE}" \
		--backtitle "${CONS_BACK_TITLE}" \
		--msgbox    "${RET_MSG}" \
		            "${CONS_BOX_HEIGHT}" \
					"${CONS_BOX_ERROR_WIDTH}"

    MASTER_PAGE_PING_RESULT_CODE=$TP_PING_RESULT_OK
    MASTER_PAGE_PING_RESULT_ROLLING=0
    return
}
